<?php
/**
 * Woocommerce functions
 * @package ninja
 */

// Remove WooCommerce Updater
remove_action('admin_notices', 'woothemes_updater_notice');
// Remove woocommerce breadcrumbs
/*remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);*/
// Remove default sorting dropdown
// remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
// Remove default woocommerce sidebar
remove_action ('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
// Remove sale flash badge
add_filter('woocommerce_sale_flash', 'woo_custom_hide_sales_flash');
function woo_custom_hide_sales_flash() { return false; }

/**
 * Create opening and closing divs for product content section
 **/
function ninja_woo_opening_product_content_div(){
    $container = set_ninja_container();
    $ninja_container = $container['container_type'];
    if ( $ninja_container == 'container-fluid' ){
        echo '<div class="container">';
    }
    echo '<div id="product-content" class="row">';
    echo '<div class="product-inner-content col-md-9 order-1">';
}
add_action('woocommerce_before_main_content', 'ninja_woo_opening_product_content_div', 30);

function ninja_woo_closing_product_content_div(){
    echo '</div><!-- .product-inner-content -->';
    echo '<div id="product-sidebar" class="col-md-3 order-2">';
        if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Product Sidebar') ) : endif;
    echo '</div> <!-- #product-sidebar -->';
    echo '</div> <!-- #product-content -->';

    $container = set_ninja_container();
    $ninja_container = $container['container_type'];
    if ( $ninja_container == 'container-fluid' ){
        echo '</div><!-- .container -->';
    }
}
add_action('woocommerce_after_main_content', 'ninja_woo_closing_product_content_div', 5);
/**
 * Remove add to cart button on shop
 */
//remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
/**
 * Add Read More button for products on shop
 */
function replace_add_to_cart() {
    global $product;
    $link = $product->get_permalink();
    _e("<a class='btn btn-default read-more' href=". esc_attr($link) .">Read More</a>");
}
// add_action('woocommerce_after_shop_loop_item','replace_add_to_cart');
/**
 * Change number of products per row on shop
 */
if (!function_exists('loop_columns')) {
    function loop_columns() {
        return 3; // products per row
    }
}
add_filter('loop_shop_columns', 'loop_columns');
/**
 * Change number of related products on product page
 */ 
add_filter( 'woocommerce_output_related_products_args', 'ninja_related_products_args' );
function ninja_related_products_args( $args ) {
    $args['posts_per_page'] = 3; // max related products
    $args['columns'] = 3; // products per row
    return $args;
}
/**
 * Reorder product meta in single page to be below product title
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 10 );
/**
 * Remove product price
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 20 );
/**
 * Remove after shop loop item title
**/
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating',5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price',10);
/**
 * Remove upsell display, tabs
 */
//remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
//remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
/**
 * Remove reviews tab
 */
/* add_filter( 'woocommerce_product_tabs', 'ninja_woo_remove_reviews_tab', 98 );
function ninja_woo_remove_reviews_tab($tabs) {
    unset($tabs['reviews']);
    return $tabs;
} */
/*
 * Replace WooCommerce Default Pagination with WP-PageNavi
 */
remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);
function woocommerce_pagination() {
    ninja_navigation();
}
add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10);
/**
 * Remove unnecessary product data tabs on backend
 */
function remove_tab($tabs){
    return($tabs);
}
add_filter('woocommerce_product_data_tabs', 'remove_tab', 10, 1);
/**
 * Product Lightbox
*/
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );
add_theme_support( 'wc-product-gallery-zoom' );