<?php

/**
 * Social  Widget
 * Ninja Theme
 */
class ninja_social_widget extends WP_Widget
{
	 function __construct(){
            
            $widget_ops = array('classname' => 'ninja-social','description' => esc_html__( "Ninja Social Widget" ,'ninja') );
            parent::__construct('ninja-social', esc_html__('Ninja Social Widget','ninja'), $widget_ops);
            
    }

    function widget($args , $instance) {
    	extract($args);
        $title = isset($instance['title']) ? $instance['title'] : esc_html__('Follow us' , 'ninja');

        echo $before_widget;
        echo $before_title;
        echo $title;
        echo $after_title;

        /**
         * Widget Content
         */ ?>

        <!-- social icons -->
        <div class="social-icons-wrapper">

            <?php ninja_social_icons(); ?>

        </div><!-- end social icons --><?php

        echo $after_widget;
    }

    function form($instance) {
      if(!isset($instance['title'])) $instance['title'] = esc_html__('Follow Us' , 'ninja'); ?>

      <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title ','ninja') ?></label>

      <input type="text" value="<?php echo esc_attr($instance['title']); ?>"
                          name="<?php echo $this->get_field_name('title'); ?>"
                          id="<?php $this->get_field_id('title'); ?>"
                          class="widefat" />
      </p><?php
    }

}
?>