/**
 * Javascript functions to administrator pane
 *
 * @package YITH Woocommerce Request A Quote
 * @since   1.0.0
 * @version 1.0.0
 * @author  YITH
 */
jQuery(function ($) {
	"use strict";
	var select = $(document).find('.yith-ywraq-chosen'),
		is_valid_email = function (email) {
			var pattern = new RegExp(/^[^\s@]+@[^\s@]+\.[^\s@]+$/i);
			return pattern.test(email);
		},
		blockParams = {
			message: null,
			overlayCSS: {background: '#fff', opacity: 0.7},
			ignoreIfBlocked: true
		};

	$('#_ywraq_safe_submit_field').val('');

	select.each(function () {
		if ($.fn.chosen !== undefined) {
			$(this).chosen({
				width: '350px',
				disable_search: true,
				multiple: true
			})
		}
	});


	//Contact form selection
	var yit_contact_form = $('select.yit-contact-form').parent().parent(),
		contact_form_7 = $('select.contact-form-7').parent().parent(),
		gravity_forms = $('select.gravity-forms').parent().parent();

	$('select#ywraq_inquiry_form_type').change(function () {

		var option = $('option:selected', this).val();

		switch (option) {
			case "yit-contact-form":
				yit_contact_form.show();
				contact_form_7.hide();
				gravity_forms.hide();
				break;
			case "contact-form-7":
				yit_contact_form.hide();
				gravity_forms.hide();
				contact_form_7.show();
				break;
			case "gravity-forms":
				yit_contact_form.hide();
				contact_form_7.hide();
				gravity_forms.show();
				break;
			default:
				yit_contact_form.hide();
				contact_form_7.hide();
				gravity_forms.hide();
		}

	}).change();


	//Order functions
	$('#ywraq_submit_button').on('click', function (e) {
		e.preventDefault();
		$('#_ywraq_safe_submit_field').val('send_quote');

		$(this).closest('form').submit();
	});

	//Order functions
	$('#ywraq_pdf_button').on('click', function (e) {
		e.preventDefault();
		var $t = $(this),
			mainForm = $t.closest('form');
		$('#_ywraq_safe_submit_field').val('create_preview_pdf');
		$.post(document.location.href, mainForm.serialize())
			.done(function (result) {
				if (result !== '') {
					var c = $("<div></div>").html(result),
						pdfButton = c.find('#ywraq_pdf_button'),
						pdf = pdfButton.data('pdf');
				}else{
					var pdfButton = $(document).find('#ywraq_pdf_button'),
						pdf = pdfButton.data('pdf');
				}

				if (pdf) {
					window.open(
						pdf, "_blank");
				}
			});
		$('#_ywraq_safe_submit_field').val('');
	});

	$('#ywraq_check_email').on('click', function (e) {
		e.preventDefault();
		var $t = $(this),
			email = $('#_ywraq_email_preview_email').val(),
			mainForm = $t.closest('form');

		if (is_valid_email(email)) {
			$('#_ywraq_safe_submit_field').val('send_email_preview');
			$t.block(blockParams);
			$.post(document.location.href, mainForm.serialize())
				.done(function () {
					$t.unblock();
					$('.ywraq-email-success').show();
					setTimeout(function () {
						$('.ywraq-email-success').hide('slow');
					}, 3000);
				});
		} else {
			$('.ywraq-email-error').show();
		}
	});

	$('#_ywraq_email_preview_email').on('change click', function () {
		var email = $(this).val();
		if (is_valid_email(email)) {
			$('.ywraq-email-error').hide();
		} else {
			$('.ywraq-email-error').show();
		}
	});

	//datepicker
	if ($('#_ywcm_request_expire').length > 0) {
		$('#_ywcm_request_expire').each(function () {
			$.datepicker.setDefaults({
				gotoCurrent: true,
				dateFormat: 'yy-mm-dd'
			});
			$(this).datepicker('option', 'minDate', "1d");

		});
	}

	/*
		//Metabox Pay Quote Now
		$(document).on('change', $('#_ywraq_pay_quote_now'), function () {
			check_pay_quote_now();
		});

		//Expiry date
		$(document).on('change', $('#_ywraq_enable_expiry_date'), function () {
			check_expiry_date();
		});

		function check_pay_quote_now() {
			var value = $('#_ywraq_pay_quote_now').val(),
				$dom1 = $('#_ywraq_checkout_info').closest('.the-metabox'),
				$dom2 = $('#_ywraq_lock_editing').closest('.the-metabox'),
				$dom3 = $('#_ywraq_disable_shipping_method').closest('.the-metabox'),
				$dom5 = $('#_ywraq_deposit_rate').closest('.the-metabox'),
				$dom4 = $('#_ywraq_deposit_enable').closest('.the-metabox');
			if (value == 0 || value == 'no') {
				$dom1.show();
				$dom2.show();
				$dom3.show();
				$dom4.show();
				$dom5.show();
			} else {
				$dom1.hide();
				$dom2.hide();
				$dom3.hide();
				$dom4.hide();
				$dom5.hide();
			}
		}

		function check_expiry_date() {
			var value = $('#_ywraq_enable_expiry_date').val(),
				$dom1 = $('#_ywcm_request_expire').closest('.the-metabox');

			if (value == 0 || value == 'no') {
				$dom1.hide();
			} else {
				$dom1.show();
			}
		}
		check_expiry_date();

		check_pay_quote_now();
	*/
	//Metabox Pay Quote Now
	$(document).on('change', $('#_ywraq_deposit_enable'), function () {
		check_deposit_enabled();
	});

	function check_deposit_enabled() {
		var value = $('#_ywraq_deposit_enable').val(),
			pay_now = $('#_ywraq_pay_quote_now').val(),
			$rate = $('#_ywraq_deposit_rate').closest('.the-metabox');
		if (pay_now == 0 || pay_now == 'no') {
			if (value == 0 || value == 'no') {
				$rate.hide();
			} else {
				$rate.show();
			}
		}

	}

	check_deposit_enabled();


	$('#ywraq_pdf_file').attr('disabled', 'disabled');


	/**
	 * Editor integration forms
	 * @type {*|jQuery}
	 */
	var link = $(document).find('.ywraq_form_link'),
		getFormEditorLink = function getFormEditorLink(formType, value) {

			if (value === null || value == '') {
				return '';
			}

			if (formType === 'contact-form-7') {
				return '&post=' + value + '&action=edit';
			}

			if (formType === 'gravity-forms') {
				return '&id=' + value;
			}

			if (formType === 'ninja-forms') {
				return '&form_id=' + value;
			}

			if (formType === 'wpforms') {
				return '&view=fields&form_id=' + value;
			}

		};

	link.each(function () {
		var $t = $(this),
			select = $t.closest('.forminp-select').find('select'),
			link = $t.attr('href'),
			formType = $t.data('type'),
			value = select.val();

		$t.attr('href', link + getFormEditorLink(formType, value));

		select.on('change', function () {
			var newvalue = $(this).val();
			$t.attr('href', link + getFormEditorLink(formType, newvalue));
		});
	});


	/*FORM SETTINGS FIELD*/

	var tr_view_details = $('#ywraq_message_to_view_details').closest('tr'),
		tr_view_thank_you_page = $('#ywraq_thank_you_page').closest('tr');

	$(document).on('change', 'input[name="ywraq_how_show_after_sent_the_request"]:checked', function (e) {

		var value = $(this).val();

		if ('simple_message' !== value) {
			tr_view_details.hide();

		} else {

			$('#ywraq_enable_link_details').trigger('change');

		}
		if ('thank_you_page' !== value) {
			tr_view_thank_you_page.hide();
		} else {

			tr_view_thank_you_page.show();

		}
	});

	$(document).find('input[name="ywraq_how_show_after_sent_the_request"]').trigger('change');

	var radio_checked = $(document).find('input[name="ywraq_how_show_after_sent_the_request"]:checked').val();


	if ('simple_message' !== radio_checked) {
		tr_view_details.hide();
	}


	$('.yith-plugin-fw.metaboxes-tab.yith-plugin-ui').find('[data-deps]').each(function () {

		var t = $(this),
			wrap = t.closest('.the-metabox'),
			deps = t.attr('data-deps').split(','),
			values = t.attr('data-deps_value').split(','),
			conditions = [];

		$.each(deps, function (i, dep) {
			$('#' + dep).on('change', function () {

				var value = this.value,
					check_values = '';

				// exclude radio if not checked
				if (this.type == 'radio' && !$(this).is(':checked')) {
					return;
				}

				if (this.type == 'checkbox') {
					value = $(this).is(':checked') ? 'yes' : 'no';
				}

				check_values = values[i] + ''; // force to string
				check_values = check_values.split('|');
				conditions[i] = $.inArray(value, check_values) !== -1;

				if ($.inArray(false, conditions) === -1) {
					wrap.fadeIn();
				} else {
					wrap.fadeOut();
				}

			}).change();
		});
	});

	$('.yith-plugins_page_yith_woocommerce_request_a_quote .form-table').find('[data-deps]').each(function () {

		var t = $(this),
			wrap = t.closest('tr'),
			deps = t.attr('data-deps').split(','),
			values = t.attr('data-deps_value').split(','),
			conditions = [];

		$.each(deps, function (i, dep) {
			$('[name="' + dep + '"]').on('change', function () {

				var value = this.value,
					check_values = '';

				// exclude radio if not checked
				if (this.type == 'radio' && !$(this).is(':checked')) {
					return;
				}

				if (this.type == 'checkbox') {
					value = $(this).is(':checked') ? 'yes' : 'no';
				}

				check_values = values[i] + ''; // force to string
				check_values = check_values.split('|');
				conditions[i] = $.inArray(value, check_values) !== -1;

				if ($.inArray(false, conditions) === -1) {
					wrap.fadeIn();
				} else {
					wrap.fadeOut();
				}

			}).change();
		});
	});

	/**
	 * Move the create page option near page select on Request a quote page options.
	 */
	var createToPage = function () {
		var $single_select_page = $('.single_select_page'),
			$create_page = $('.ywraq-create-page'),
			$row_to_hide = $create_page.closest('tr');
		if ($single_select_page.length > 0) {
			$single_select_page.find('.description').before($create_page);
			$row_to_hide.hide();
		}
	}

	createToPage();


	/** Customer request editor **/
	$(document).on('click', '.yith-pencil.customer-request-editor', function () {
		var $t = $(this),
			$wrapper = $t.closest('.customer-request-field-wrapper');
		if ($wrapper.hasClass('edit')) {
			$wrapper.removeClass('edit');
			$wrapper.find('input, textarea').prop('readonly', true);
		} else {
			$wrapper.addClass('edit');
			$wrapper.find('input, textarea').prop('readonly', false);
		}
	});

	$('#ywraq_enable_expired_time').change(function () {

		if ($('#ywraq_expired_time').parent().parent().parent().hasClass('yith-disabled')) {
			$('#ywraq_expired_time_days').attr('disabled', 'disabled');
		} else {
			$('#ywraq_expired_time_days').attr('disabled', false);
		}

	}).change();

	if (yith_ywraq_admin.is_raq_panel) {
		$('#doaction, #post-query-submit').on('click', function (e) {
			e.preventDefault();
			window.onbeforeunload = null;

			var $t = $(this);
			$t.closest('form').submit();
		});
	}

});