fbuilderjQuery = (typeof fbuilderjQuery != 'undefined' ) ? fbuilderjQuery : jQuery;
fbuilderjQuery[ 'fbuilder' ] = fbuilderjQuery[ 'fbuilder' ] || {};
fbuilderjQuery[ 'fbuilder' ][ 'modules' ] = fbuilderjQuery[ 'fbuilder' ][ 'modules' ] || {};

fbuilderjQuery[ 'fbuilder' ][ 'modules' ][ 'datetime' ] = {
	'tutorial' : 'https://cff.dwbooster.com/documentation#datetime-module',
	'toolbars'		: {
		'datetime' : {
			'label' : 'Date Time functions',
			'buttons' : [
							{ "value" : "DATEOBJ", 				"code" : "DATEOBJ(", 			"tip" : "<p>Get the date object from an string representation of date. <strong>DATEOBJ( date_string, format )</strong></p><p><strong>DATEOBJ(&quot;2013-05-21&quot;, &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>date object</strong></p>" },
							{ "value" : "YEAR", 				"code" : "YEAR(", 				"tip" : "<p>Get the year from an string representation of date. <strong>YEAR( date_string, format )</strong></p><p><strong>YEAR(&quot;2013-05-21&quot;, &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>2013</strong></p>" },
							{ "value" : "MONTH", 				"code" : "MONTH(", 				"tip" : "<p>Get the month from an string representation of date. <strong>MONTH( date_string, format )</strong></p><p><strong>MONTH(&quot;2013-05-21&quot;, &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>5</strong></p>" },
							{ "value" : "DAY", 					"code" : "DAY(", 				"tip" : "<p>Get the days from an string representation of date. <strong>DAY( date_string, format )</strong></p><p><strong>DAY(&quot;2013-05-21&quot;, &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>21</strong></p>" },
							{ "value" : "WEEKDAY", 				"code" : "WEEKDAY(", 			"tip" : "<p>Get the week day from an string representation of date. <strong>WEEKDAY( date_string, format )</strong></p><p><strong>WEEKDAY(&quot;2013-10-27&quot;, &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>1</strong> Sunday is the day number one</p>" },
							{ "value" : "WEEKNUM", 				"code" : "WEEKNUM(", 			"tip" : "<p>Get the week number from an string representation of date, a year has 53 weeks. <strong>WEEKNUM( date_string, format )</strong></p><p><strong>WEEKNUM(&quot;2013-10-27&quot;, &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>43</strong></p>" },
							{ "value" : "HOURS", 				"code" : "HOURS(", 				"tip" : "<p>Get hours from an string representation of datetime. <strong>HOURS( datetime_string, format )</strong></p><p><strong>HOURS(&quot;2013-10-27 01:21&quot;, &quot;yyyy-mm-dd hh:ii&quot;)</strong></p><p>Result: <strong>1</strong></p>" },
							{ "value" : "MINUTES", 				"code" : "MINUTES(", 			"tip" : "<p>Get minutes from an string representation of datetime. <strong>MINUTES( datetime_string, format )</strong></p><p><strong>MINUTES(&quot;2013-10-27 01:22&quot;, &quot;yyyy-mm-dd hh:ii&quot;)</strong></p><p>Result: <strong>22</strong></p>" },
							{ "value" : "SECONDS", 				"code" : "SECONDS(", 			"tip" : "<p>Get seconds from an string representation of datetime. <strong>SECONDS( datetime_string, format )</strong></p><p><strong>SECONDS(&quot;2013-10-27 01:22:56&quot;, &quot;yyyy-mm-dd hh:ii:ss&quot;)</strong></p><p>Result: <strong>56</strong></p>" },
							{ "value" : "NOW", 					"code" : "NOW(", 				"tip" : "<p>Get a date object with the current day-time information. <strong>NOW()</strong></p><p><strong>NOW()</strong></p><p>Result: <strong>2013-10-27 01:42:19</strong></p>" },
							{ "value" : "TODAY", 				"code" : "TODAY(", 				"tip" : "<p>Get a date object with the current day information, without the time part. <strong>TODAY()</strong></p>" },
							{ "value" : "EOMONTH", 				"code" : "EOMONTH(", 				"tip" : "<p>Get the last day of the month. <strong>EOMONTH(date_obj, number)</strong> where the number parameter is optional.</p><p><strong>EOMONTH(DATEOBJ(&quot;2021-03-04&quot;))</strong> Result: <strong>Mar 31 2021</strong></p><p><strong>EOMONTH(DATEOBJ(&quot;2021-03-04&quot;), 4)</strong> Result: <strong>Jul 31 2021</strong></p><p><strong>EOMONTH(DATEOBJ(&quot;2021-03-04&quot;), -3)</strong> Result: <strong>Dec 31 2020</strong></p>" },
							{ "value" : "DATEDIFF", 			"code" : "DATEDIFF(", 			"tip" : "<p>Get the difference between two dates strings representation</p><p><strong>DATEDIFF(date_one, date_two, date_format, return)</strong></p><p>The function return an object, whose value depends of argument &quot;return&quot;</p><p>Possible values of return argument:<br />d - return the number of days between two dates<br />m - return the number of months between two dates, and remaining days<br />y - return the number of years between two dates, remaining months, and remaining days</p><p><strong>DATEDIFF(&quot;2013-10-27&quot;, &quot;2012-06-22&quot;, &quot;yyyy-mm-dd&quot;, &quot;y&quot;)[&quot;months&quot;]</strong><p><p>Result:<strong> 5 </strong></p>" },
							{ "value" : "DATETIMESUM", 			"code" : "DATETIMESUM(",		"tip" : "<p>Increases the date-time string representation in the number of seconds, minutes, hours, days, months, or years, passed as parameter.</p><p><strong>DATETIMESUM( date_string, format, number, to_increase, ignore_weekend )</strong></p><p>ignore_weekend is an optional parameter that applies only to days sum. It ignores Saturdays and Sundays.</p><p>DATETIMESUM(&quot;2013-10-27&quot;, &quot;yyyy-mm-dd&quot;, 5, &quot;d&quot;)</p><p>Result: <strong>The date object representation of 2013/11/01</strong></p>" },
							{ "value" : "DECIMALTOTIME", "code" : "DECIMALTOTIME(",	"tip" : "<p>Converts a decimal number to a time format text. The operation requires three parameters, the decimal number, character indicating the decimal representation (&quot;y&quot; for years, &quot;m&quot; for months, &quot;d&quot; for days, &quot;h&quot; for hours, &quot;i&quot; for minutes, and &quot;s&quot; for seconds), text for time format (&quot;h:i:s&quot;).</p><p><strong>DECIMALTOTIME( decimal, format, time format )</strong></p><p>DECIMALTOTIME(938405,&quot;s&quot;,&quot;d days, h hours, i minutes, and s seconds&quot;)</p><p>Result: <strong>10 days, 20 hours, 40 minutes, and 5 seconds</strong></p>" },
                            { "value" : "TIMETODECIMAL", "code" : "TIMETODECIMAL(",	"tip" : "<p>Converts a time text to a decimal number. The operation requires three parameters, the text with time representation, the time format representation (&quot;h:i:d&quot;), character with the output format (&quot;y&quot; for years, &quot;m&quot; for months, &quot;d&quot; for days, &quot;h&quot; for hours, &quot;i&quot; for minutes, and &quot;s&quot; for seconds).</p><p><strong>TIMETODECIMAL( time text, time format, output format )</strong></p><p>TIMETODECIMAL(&quot;20:40:5&quot;,&quot;h:i:s&quot;,&quot;s&quot;)</p><p>Result: <strong>74405</strong></p>" },
							{ "value" : "GETDATETIMESTRING", 	"code" : "GETDATETIMESTRING(",	"tip" : "<p>Returns the string representation of a date object</p><p><strong>GETDATETIMESTRING( datetime_object, format )</strong></p><p><strong>GETDATETIMESTRING(TODAY(), &quot;yyyy-mm-dd&quot;)</strong></p><p>Result: <strong>2013-10-27</strong></p>" }
						]
		}
	}
};